﻿//////////////////////////////////////////////
// DepthStencilStateManager.h
//
//////////////////////////////////////////////

/// Defines / Macros -------------------------

#pragma once

/// Includes ---------------------------------

// nkGraphics
#include "../Dll/DllDefines.h"

#include "../Utils/Manager.h"

#include "DepthStencilState.h"

// nkCommon
#include <nilkinsCommon/Patterns/MaybeSingletonClass.h>

// nkMemory
#include <NilkinsMemory/Pointers/UniquePtr.h>

/// Class ------------------------------------

namespace nkGraphics
{
	class DLL_GRAPHICS_EXPORT DepthStencilStateManager : public Manager<DepthStencilState>, public nkCommon::MaybeSingletonClass<DepthStencilStateManager>
	{
		public :

			// Getters
			DepthStencilState* getDefaultState () const ;

		private :

			// Constructors
			DepthStencilStateManager (bool isSingleton) noexcept ;
			DepthStencilStateManager (System* system) noexcept ;

			// Lifetime
			void _initializeDefaultState () ;

		private :
		
			// Attributes
			nkMemory::UniquePtr<DepthStencilState> _defaultState ;

		private :

			friend class nkCommon::MaybeSingletonClass<DepthStencilStateManager> ;
			friend class System ;
	} ;
}